#ifndef _TEXTURESLICER_H_
#define _TEXTURESLICER_H_
#include "Data.h"
#include "CVector.h"

struct Edge {
	public:
		Edge(int i, int j) {nV1=i; nV2=j;}
		Edge() {nV1=0; nV2=0;}
		int nV1, nV2;
};

class TextureSlicer {
public:
	TextureSlicer();
	~TextureSlicer();
	//texture slicing drawing routine
	void render(Data* theData);
	inline void incStepSize(float inc) {
		m_StepSize += inc;
		if (m_StepSize < 0.0005)
			m_StepSize = 0.0005;
	}	static const int m_pEdgeList[8][12];
protected:
	//near and far give the distance
	//nearIdx and farIdx gives the indices of the near and far vertices res[ectively
	void getRayBoxIntersection(CVector rayDirn, double& near, double& far, int& nearIdx, int& farIdx);

	CVector  m_pVertices[8]; //the 8 vertices of our bounding box
	Edge     m_pEdges[12]; //the 12 edges of the box
	double m_StepSize; //sample interval

};

#endif
