/* ---------------------------------------------------------------------------
 * This software is in the public domain, furnished "as is", without technical
 * support, and with no warranty, express or implied, as to its usefulness for
 * any purpose.

 * Author: Wil Braithwaite.
 *
 */

#ifndef CUDASCHEDULER_H_INCLUDED
#define CUDASCHEDULER_H_INCLUDED

#include "gl_utils.h"
#include "std_utils.h"
#include <memory>
#include <vector>

#if defined( _WIN32 )

#else
#include <GL/glx.h>
#include <X11/Xlib.h>
#endif

namespace Easy
{

//---------------------------------------------------------------------------------------
#if defined(_WIN32)

struct GlContextData
{
	HDC hdc;
	HGLRC hglrc;
};

#else

struct GlContextData
{
	Display* xdisplay;
	GLXContext glxcontext;
	Window xwindow;
};

#endif

//---------------------------------------------------------------------------------------
class CudaSchedulerTask : public Thread
{
    friend class CudaScheduler;
    CudaSchedulerTask(const CudaSchedulerTask &);
    CudaSchedulerTask &operator=(const CudaSchedulerTask &);

public:
    class CudaScheduler *_scheduler;
    int _index;
    int _deviceIndex;
    volatile bool _exitFlag;
	GlContextData _glContextData;
    Mutex _readyLock;

private:

    CudaSchedulerTask(class CudaScheduler *s, int i, GlContextData _glContextData, int use_gpu=0);

    virtual void onExecute();
};

//---------------------------------------------------------------------------------------
class CudaSchedulerJob
{
private:
    bool _deleteAtExit;

protected:
    int _deviceIndex;

public:

    virtual ~CudaSchedulerJob()
    {
    }

    virtual bool onExecute(CudaSchedulerTask *task)=0;

    friend class CudaSchedulerTask;
    friend class CudaScheduler;
};

//---------------------------------------------------------------------------------------
class CudaScheduler
{
    friend class CudaSchedulerTask;

    Mutex _listLock;
    static Mutex lock;

    Semaphore _itemSemaphore;
    Semaphore _allDone;

    std::vector< CudaSchedulerJob* > _job;

    int _nSubmitted;
    int _nDone;
    int _nBusy;

    int _startDevice;

public:
    static int debugging;

	//! list of tasks (one per GPU used)
    std::vector<CudaSchedulerTask *> task;

	bool useGL;

#if defined(_WIN32)
	HDC _display;
	HGLRC _glcontext;
#else
    Display* _display;
    GLXContext _glcontext;
#endif

public:

#if defined(_WIN32)
    CudaScheduler(int startDevice=0, int numDevices=1, HDC display=NULL, HGLRC glcontext=NULL);
#else
    CudaScheduler(int startDevice=0, int numDevices=1, Display *display=NULL, GLXContext glcontext=NULL);
#endif
	~CudaScheduler();

    void add(CudaSchedulerJob *j, int index=-1, bool owner=true);

    void waitAllDone();

    void endTasks();
};

}

#endif // CUDASCHEDULER_H_INCLUDED
