/* ---------------------------------------------------------------------------
 * This software is in the public domain, furnished "as is", without technical
 * support, and with no warranty, express or implied, as to its usefulness for
 * any purpose.

 * Author: Wil Braithwaite.
 *
 */

#ifndef GLUTAPP_H_INCLUDED
#define GLUTAPP_H_INCLUDED

#if defined(EASY_USE_GLUT)

#include "std_utils.h"

namespace Easy
{
namespace Profiler
{
	class Manager;
}


class GlutApp
{
public:
    static GlutApp *app;

protected:
    int argc;
    char **argv;
    int glut_mode;
    static bool draw_profiler;
    static bool paused;
    static Timer timer;

public:
    static bool _exitComplete;

    float ifps;
    static unsigned int width;
    static unsigned int height;
    static unsigned int fov;

    static int buttonState;
    static int ox, oy;

    static bool using_idle;

public:
    GlutApp(int _argc, char **_argv, int mode=0|16|2);//GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);

    void Run();

    void DrawProfile(Easy::Profiler::Manager* profiler);
    void SetPause(bool state);

    void Repaint();

    static void _display();
    static void _reshape(int w, int h);

    static float computeFPS(unsigned int fpsLimit=1);

    void SetTitle(const char* title);

public:
    // methods to override
    virtual const char *Title();
    virtual void OnInit();
    virtual void OnRender();
    virtual void OnOverlay();
    virtual void OnUpdate();
    virtual void OnReshape(unsigned int w, unsigned int h, unsigned int fov);
    virtual void OnIdle();
    virtual bool OnKey(unsigned char key);
    virtual void OnExit();

    void* GetDisplay();
    void* GetGlContext();
};

}

#endif

#endif // GLUTAPP_H_INCLUDED
