#include "Profiler.h"

//template<> Easy::Profiler::Manager* Singleton<Easy::Profiler::Manager>::_singleton = 0;

namespace Easy
{
namespace Profiler
{

//-------------------------------------------------------------------------------------------
Node::Node( const char *_name, Node *_parent)
        : name(_name), calls(0), elapsed_time(0), start_time(0), recursion_counter(0), parent(_parent), child(NULL), sibling(NULL)
{
    Setup(_name, _parent);
}

//-------------------------------------------------------------------------------------------
void Node::Reset()
{
    calls = 0;
    elapsed_time = 0.f;

    if (child)
        child->Reset();
    if (sibling)
        sibling->Reset();
}

//-------------------------------------------------------------------------------------------
void Node::Setup(const char *_name, Node *_parent)
{
    name = _name;
    calls = 0;
    elapsed_time = 0;
    start_time = 0;
    recursion_counter = 0;
    parent = _parent;
    child = NULL;
    sibling = NULL;

    if(parent)
    {
        sibling = parent->child;
        parent->child = this;
    }
}

//-------------------------------------------------------------------------------------------
Node::~Node()
{
    delete child;
    delete sibling;
}

//-------------------------------------------------------------------------------------------
Node *Node::FindChild(const char *name)
{
    Node *c = child;
    while (c)
    {
        if (c->name == name)
            return c;
        c = c->sibling;
    }
    return NULL;
}

//-------------------------------------------------------------------------------------------
Node *Node::AddChild(const char *name)
{
    Node *node = new Node(name, this);
    node->sibling = child;
    child = node;
    return node;
}

//-------------------------------------------------------------------------------------------
Node *Node::EnsureChild(const char *name)
{
    Node *c = FindChild(name);
    if (c != NULL)
        return c;
    return AddChild(name);
}

//-------------------------------------------------------------------------------------------
void Node::Call(void)
{
}

//-------------------------------------------------------------------------------------------
bool Node::Return(void)
{
	return false;
}

//-------------------------------------------------------------------------------------------
ProfileIterator::ProfileIterator(Node *start)
{
    current_parent = start;
    current_child = current_parent->Child();
}

//-------------------------------------------------------------------------------------------
void ProfileIterator::First()
{
    current_child = current_parent->Child();
}

//-------------------------------------------------------------------------------------------
void ProfileIterator::Next()
{
    current_child = current_child->Sibling();
}

//-------------------------------------------------------------------------------------------
bool ProfileIterator::IsDone()
{
    return current_child == NULL;
}

//-------------------------------------------------------------------------------------------
bool ProfileIterator::EnterChild(int index)
{
    Node *newChild = NULL;
    newChild = current_parent->Child();
    while ( (newChild != NULL) && (index != 0) )
    {
        index--;
        newChild = newChild->Sibling();
    }

    if (newChild != NULL)
    {
        current_parent = newChild;
        current_child = current_parent->Child();
        return true;
    }
    // leave current child the same
    return false;
}

//-------------------------------------------------------------------------------------------
void ProfileIterator::EnterParent( void )
{
    if ( current_parent->Parent() != NULL )
        current_parent = current_parent->Parent();
    current_child = current_parent->Child();
}

//-------------------------------------------------------------------------------------------
Node *Manager::AddNode(const char *name, Node *parent, const char *type)
{
    Node *p;
    p = new Node(name, parent);
    node_count++;
    return p;
}

//-------------------------------------------------------------------------------------------
Manager::Manager()
	:
	node_root("root", NULL),
	current_node(&node_root)
{
    frame_counter = 0;
    reset_time = 0;
    node_count = 0;
	timer.Reset();
}

//-------------------------------------------------------------------------------------------
void Manager::Push(const char * name, const char *type)
{
    if (name != current_node->Name())
    {
        Node *c = current_node->FindChild(name);
        if (c != NULL)
            current_node = c;
        else
            current_node = AddNode(name, current_node, type);
    }

	current_node->calls++;
	// only do this if it is the first recursion...
    if (current_node->recursion_counter++ == 0)
    {
		current_node->start_time = timer.Value();
    }
}

//-------------------------------------------------------------------------------------------
Node *Manager::FindNode(const char *name, Node *root)
{
	if(!root)
		root = &node_root;

    Node *node = root;
    if (strcmp(name, node->name)==0)
        return node;

    Node *child = node->child;
    while (child)
    {
        node = FindNode(name, child);
        if (node != NULL)
            return node;
        child = child->sibling;
    }
    return NULL;
}

//-------------------------------------------------------------------------------------------
void Manager::Pop()
{
    // Return will indicate whether we should back up to our parent (we may
    // be profiling a recursive function)

    if (--current_node->recursion_counter == 0 && current_node->calls != 0)
    {
        float t;
        //GetTicks(&t);
		t = timer.Value();
        t -= current_node->start_time;
        current_node->elapsed_time += (float)t / GetTickRate();
    }
    
	if(current_node->recursion_counter == 0)
		current_node = current_node->Parent();
}

//-------------------------------------------------------------------------------------------
void Manager::Reset()
{
    node_root.Reset();
    frame_counter = 0;
	//GetTicks(&reset_time);
	reset_time = 0;
	timer.Reset();
}

//-------------------------------------------------------------------------------------------
void Manager::IncrementFrame()
{
    frame_counter++;
}

//-------------------------------------------------------------------------------------------
float Manager::ElapsedTime()
{
    float t;
	//GetTicks(&t);
	t = timer.Value();
    t -= reset_time;
    return (float)t / GetTickRate();
}

//-------------------------------------------------------------------------------------------
void Manager::GetTicks(float* ticks)
{
    *ticks = timer.Value();
}

//-------------------------------------------------------------------------------------------
float Manager::GetTickRate()
{
    return 1;
}

//-------------------------------------------------------------------------------------------
static void RecurseProfile(ProfileIterator *iter,int global_xoffset, int &yoffset,int indent,float scale, const int numFrames)
{
    //int xoffset;
    for (;iter->IsDone() == false;iter->Next())
    {
        if (iter->Calls() == 0)
            continue;

        float thisscale = 1.f;
        if (iter->ParentElapsedTime() > 0.f)
            thisscale = iter->ElapsedTime();///iter->ParentElapsedTime();

        int percentage = (int)(100.f*thisscale);

        float count = numFrames;
        if (count <= 0)
            count = 1;

        //float averageTimePerCall = float(iter->ElapsedTime()*1000.f)/iter->Calls();
        float timePerFrame = float(iter->ElapsedTime()*1000.f)/count;
        int callsPerFrame = int(iter->Calls()/count);

        std::string t = Stringf("%05d %0.3fms %03dfps %03d%%",callsPerFrame, timePerFrame, int(1000.f/timePerFrame), percentage);
        std::cout << iter->Name() << ":" << t << std::endl;

        ProfileIterator iter2(iter->ThisNode());
        RecurseProfile(&iter2,global_xoffset,yoffset,indent+1,thisscale*scale,numFrames);
    }
}

//-------------------------------------------------------------------------------------------
void Manager::DumpProfile()
{
    ProfileIterator *iter = CreateIterator();
    if (!iter->IsDone())
    {
        int startx = 32;
        int starty = 32;
        int y = starty;
        RecurseProfile(iter,startx,y,0,1,ElapsedFrames());
    }
    delete iter;
}

//-------------------------------------------------------------------------------------------
}
}
