/* ---------------------------------------------------------------------------
 * This software is in the public domain, furnished "as is", without technical
 * support, and with no warranty, express or implied, as to its usefulness for
 * any purpose.

 * Author: Wil Braithwaite.
 *
 */

#ifndef CUDA_STD_UTILS_H_INCLUDED
#define CUDA_STD_UTILS_H_INCLUDED

#include <iostream>
#include <cuda_runtime.h>

//namespace Easy
//{

inline static std::ostream &operator<< (std::ostream &s, const float4 &v)
{
    s << v.x << " " << v.y << " " << v.z << " " << v.w;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const uchar4 &v)
{
    s << (int)v.x << " " << (int)v.y << " " << (int)v.z << " " << (int)v.w;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const float3 &v)
{
    s << v.x << " " << v.y << " " << v.z;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const uint3 &v)
{
    s << v.x << " " << v.y << " " << v.z;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const int3 &v)
{
    s << v.x << " " << v.y << " " << v.z;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const uint2 &v)
{
    s << v.x << " " << v.y;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const int2 &v)
{
    s << v.x << " " << v.y;
    return s;
}

inline static std::ostream &operator<< (std::ostream &s, const dim3 &v)
{
    s << v.x << " " << v.y << " " << v.z;
    return s;
}

//}

#endif // CUDA_STD_UTILS_H_INCLUDED
