/* ---------------------------------------------------------------------------
 * This software is in the public domain, furnished "as is", without technical
 * support, and with no warranty, express or implied, as to its usefulness for
 * any purpose.

 * Author: Wil Braithwaite.
 *
 */

#ifndef GL_UTILS_H_INCLUDED
#define GL_UTILS_H_INCLUDED

#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <GL/glew.h>
#ifdef _WIN32
#include <GL/wglew.h>
#endif

#if defined(_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#else
//#include <GL/glxew.h>
#include <GL/glx.h>
#endif

#if defined(EASY_USE_GLUT)
#if defined(__APPLE__) || defined(MACOSX)
#include <GLUT/glut.h>
#else
#include <GL/freeglut.h>
#endif
#endif

#if defined(OSMac_MachO_)
#include <OpenGL/glu.h>
#else
#include <GL/glu.h>
#endif



#include "renderbuffer.h"
#include "FrameBufferObject.h"
#include "GLSLProgram.h"

namespace Easy
{
    namespace gl
    {
        const float PI = 3.142;

        bool initialize();

        bool __glCheckErrors(const char *file, const int line);

        void glColorABGR(unsigned int abgr);

        void* getContext();
        void* getDisplay();

        GLuint compileProgram(const char *vsource, const char *fsource=0, const char *gsource=0, GLenum in_geom_type=GL_POINTS, GLenum out_geom_type=GL_LINE_STRIP, GLint out_geom_count=2);
        GLuint createBuffer(int size, GLenum target, GLenum usage=GL_DYNAMIC_DRAW);
        void deleteBuffer(GLuint* id);
		GLuint createTexture2D(GLenum target, int w, int h, GLint internalformat, GLenum format);

        void drawSolidRectangle(const float lx, const float ly, const float hx, const float hy);
        void drawWirePlane(float radius=1, int steps=10);
        void drawColorAxes();
        void drawLine(float* first, float *second);
        void drawWireBox(float* first, float *second);
        void drawBox(float* first, float *second);
        void drawGridBox(float* first, float * second, float div);
        void drawLocator(float* centre, float radius);
        void drawCube(float radius=1);
        void drawWireCube(float radius=1);
        void drawSphere(float* centre, float radius=1, int n=16, int method=0, float theta1=0.f, float theta2=PI*2, float phi1=-PI/2, float phi2=PI/2);
        void drawWireSphere(float* centre, float radius=1, int n=16, int method=0, float theta1=0.f, float theta2=PI*2, float phi1=-PI/2, float phi2=PI/2);
        void drawWireCylinder(float* a, float* b, float radiusA=1, float radiusB=1, int step=8, bool cap=true);
        void drawWireCircle(float* centre, float radius=1, float dstep=8, float from=0, float to=360);

#undef drawText
        void drawText(int x, int y, const char *s, void *font=0);

    }
}

#define glCheckErrors() Easy::gl::__glCheckErrors(__FILE__,__LINE__)


#endif // UTIL_H_INCLUDED
