/* ---------------------------------------------------------------------------
 * This software is in the public domain, furnished "as is", without technical
 * support, and with no warranty, express or implied, as to its usefulness for
 * any purpose.

 * Author: Wil Braithwaite.
 *
 */

#ifndef MATH2_CUH_INCLUDED
#define MATH2_CUH_INCLUDED

#include "math_utils.h"

namespace Easy
{
//---------------------------------------------------------------------------------------
inline NVPARTICLES_CUDA_EXPORT vec4f make_vec4f(float3 v, float vw)
{
    vec4f a;
    a.x = v.x;
    a.y = v.y;
    a.z = v.z;
    a.w = vw;
    return a;
}
//---------------------------------------------------------------------------------------
inline NVPARTICLES_CUDA_EXPORT vec4f make_vec4f(float4 v)
{
    vec4f a;
    a.x = v.x;
    a.y = v.y;
    a.z = v.z;
    a.w = v.w;
    return a;
}
//---------------------------------------------------------------------------------------
inline NVPARTICLES_CUDA_EXPORT vec3f make_vec3f(float3 v)
{
    vec3f a;
    a.x = v.x;
    a.y = v.y;
    a.z = v.z;
    return a;
}
//---------------------------------------------------------------------------------------
inline NVPARTICLES_CUDA_EXPORT vec3f make_vec3f(float4 v)
{
    vec3f a;
    a.x = v.x;
    a.y = v.y;
    a.z = v.z;
    return a;
}
//---------------------------------------------------------------------------------------
inline NVPARTICLES_CUDA_EXPORT float3 make_float3(vec3f v)
{
    float3 a;
    a.x = v.x;
    a.y = v.y;
    a.z = v.z;
    return a;
}

//---------------------------------------------------------------------------------------
inline NVPARTICLES_CUDA_EXPORT float4 make_float4(vec4f v)
{
    float4 a;
    a.x = v.x;
    a.y = v.y;
    a.z = v.z;
    a.w = v.w;
    return a;
}

using ::make_float3;
using ::make_float4;
//---------------------------------------------------------------------------------------
}

#endif // MATH2_CUH_INCLUDED
