/*
 * Copyright 1993-2009 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and 
 * proprietary rights in and to this software and related documentation. 
 * Any use, reproduction, disclosure, or distribution of this software 
 * and related documentation without an express license agreement from
 * NVIDIA Corporation is strictly prohibited.
 *
 * Please refer to the applicable NVIDIA end user license agreement (EULA) 
 * associated with this source code for terms and conditions that govern 
 * your use of this NVIDIA software.
 * 
 */
 

/* Radixsort project which demonstrates the use of CUDA in a multi phase
 * sorting computation.
 * Type definitions.
 */

#ifndef _RADIXSORT_H_
#define _RADIXSORT_H_

#include <host_defines.h>

#define SYNCIT __syncthreads()

// Use 16 bit keys/values
#define SIXTEEN 0

typedef unsigned int uint;
typedef unsigned short ushort;

#if SIXTEEN
typedef struct __align__(4) {
    ushort key;
    ushort value;
#else
typedef struct __align__(8) {
    uint key;
    uint value;
#endif
} KeyValuePair;

extern "C" {
    void RadixSort(KeyValuePair *pData0, KeyValuePair *pData1, uint elements, uint bits, cudaStream_t stream=0);
}

#endif // #ifndef _RADIXSORT_H_
