/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLESPARTICLESHAPEUI_H_INCLUDED
#define NVPARTICLESPARTICLESHAPEUI_H_INCLUDED

#include "gl_utils.h"
#include <maya/MPxSurfaceShapeUI.h>
#include <maya/MDrawData.h>
#include <maya/MDrawRequest.h>
#include <maya/MPlug.h>

class NvParticlesParticleShapeUI : public MPxSurfaceShapeUI
{
public:
	NvParticlesParticleShapeUI();
	virtual ~NvParticlesParticleShapeUI();

	virtual void	getDrawRequests( const MDrawInfo & info,
									 bool objectAndActiveOnly,
									 MDrawRequestQueue & requests );
	virtual void	draw( const MDrawRequest & request,
						  M3dView & view ) const;
	virtual bool	select( MSelectInfo &selectInfo,
							MSelectionList &selectionList,
							MPointArray &worldSpaceSelectPts ) const;

	void			getDrawRequestsWireframe( MDrawRequest&,
											  const MDrawInfo& );
	void			getDrawRequestsShaded(	  MDrawRequest&,
											  const MDrawInfo&,
											  MDrawRequestQueue&,
											  MDrawData& data );

	static void* creator();

private:
	enum {
		kDrawCylinder,
		kDrawDisk,
		kDrawPartialDisk,
		kDrawSphere
	};

	enum {
		kDrawWireframe,
		kDrawWireframeOnShaded,
		kDrawSmoothShaded,
		kDrawFlatShaded,
		kLastToken
	};
};

#endif // NVPARTICLESPARTICLESHAPEUI_H_INCLUDED
