/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#include "gl_utils.h"

#include "NvParticlesPrimitiveShape.h"
#include "NvParticlesMayaStringResources.h"

#include <maya/MStatus.h>
#include <maya/MGlobal.h>
#include <maya/MObject.h>
#include <maya/MTypeId.h>

#include <maya/MAnimControl.h>
#include <maya/MSelectionList.h>

#include <maya/MItDependencyGraph.h>

#include <maya/MDataBlock.h>
#include <maya/MDataHandle.h>
#include <maya/MPlug.h>
#include <maya/MTime.h>
#include <maya/MVector.h>
#include <maya/MDoubleArray.h>
#include <maya/MFloatArray.h>
#include <maya/MVectorArray.h>
#include <maya/MPlugArray.h>
#include <maya/MPointArray.h>
#include <maya/MFloatVector.h>
#include <maya/MDagPath.h>
#include <maya/MMatrix.h>
#include <maya/MFloatMatrix.h>

#include <maya/MGeometryManager.h>
#include <maya/MGeometryRequirements.h>

#include <maya/MFnTypedAttribute.h>
#include <maya/MFnNumericAttribute.h>
#include <maya/MFnCompoundAttribute.h>
#include <maya/MFnMessageAttribute.h>
#include <maya/MFnEnumAttribute.h>
#include <maya/MFnUnitAttribute.h>
#include <maya/MFnGenericAttribute.h>

#include <maya/MFnDoubleArrayData.h>
#include <maya/MFnVectorArrayData.h>
#include <maya/MFnArrayAttrsData.h>

#include <maya/MFnCamera.h>
#include <maya/MFnMesh.h>
#include <maya/MFnDynSweptGeometryData.h>
#include <maya/MDynSweptTriangle.h>

#include <maya/MDynamicsUtil.h>

#include <maya/MItMeshPolygon.h>

#include <cassert>

#include "maya_utils.h"

#include "NvParticlesPrimitives.h"

using namespace Easy;

//-----------------------------------------------------------------------------------

MTypeId NvParticlesPrimitiveShape::id(kNvParticlesPrimitiveShapePluginId);

MObject NvParticlesPrimitiveShape::attrPrimitive;
MObject NvParticlesPrimitiveShape::attrType;
MObject NvParticlesPrimitiveShape::attrIsInterior;
MObject NvParticlesPrimitiveShape::attrEnabled;
MObject NvParticlesPrimitiveShape::attrExtents;

//-----------------------------------------------------------------------------------
void* NvParticlesPrimitiveShape::creator()
{
    return new NvParticlesPrimitiveShape();
}

//-----------------------------------------------------------------------------------
NvParticlesPrimitiveShape::NvParticlesPrimitiveShape()
{
}

//-----------------------------------------------------------------------------------
NvParticlesPrimitiveShape::~NvParticlesPrimitiveShape()
{
}

//-----------------------------------------------------------------------------------
void NvParticlesPrimitiveShape::draw( M3dView& view, const MDagPath& dagPath, M3dView::DisplayStyle style, M3dView::DisplayStatus displaystatus )
{
    MStatus status;

    MObject thisNode = thisMObject();

    MPlug plug(thisNode, attrPrimitive);

    plug.setAttribute(attrPrimitive);
    int primitive = plug.asShort();

    bool renderBounds = true;
    if (displaystatus != M3dView::kDormant)
        renderBounds = true;

    Easy::gl::initialize();

    // For consistency in primitive drawing,
    // get the worldmatrix and use that to draw.
    MMatrix modelViewMat;
    view.modelViewMatrix(modelViewMat);
    modelViewMat = dagPath.inclusiveMatrixInverse() * modelViewMat;
    float modelViewMat16[4][4];
    modelViewMat.get(modelViewMat16);

    MMatrix mxform = dagPath.inclusiveMatrix();
    float m16f[4][4];
    mxform.get(m16f);
    mat44f xform = mat44f::fromArray((float*)m16f);

    plug.setAttribute(attrExtents);
    vec3f extents;
    getFloat3Plug(plug, (float*)&extents);

    view.beginGL();

    glGetError();
    glCheckErrors();
    glPushAttrib( GL_ALL_ATTRIB_BITS);

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadMatrixf((float*)modelViewMat16);

    if ( ( style == M3dView::kFlatShaded ) || ( style == M3dView::kGouraudShaded ) )
    {
        if ( status == M3dView::kActive )
        {
            view.setDrawColor( 13, M3dView::kActiveColors );
        }
        else
        {
            view.setDrawColor( 13, M3dView::kDormantColors );
        }
    }

	NvParticles::Primitive p;
	memset(&p, 0, sizeof(NvParticles::Primitive));
	p.xform = xform;
	p.extents = extents;

    if(primitive == NvParticlesPrimitiveShape_PRIMITIVE_SPHERE)
    {
		NvParticles::Primitives::drawSphere(p);
    }
    else if(primitive == NvParticlesPrimitiveShape_PRIMITIVE_BOX)
    {
        NvParticles::Primitives::drawBox(p);
    }
    else if(primitive == NvParticlesPrimitiveShape_PRIMITIVE_PLANE)
    {
        NvParticles::Primitives::drawPlane(p);
    }
    else if(primitive == NvParticlesPrimitiveShape_PRIMITIVE_CAPSULE)
    {
        NvParticles::Primitives::drawCapsule(p);
    }

    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
    glPopAttrib();

    view.endGL();
}

//-----------------------------------------------------------------------------------
bool NvParticlesPrimitiveShape::isBounded() const
{
    return false;
}

//-----------------------------------------------------------------------------------
MBoundingBox NvParticlesPrimitiveShape::boundingBox() const
{
    return inherited::boundingBox();
}

//-----------------------------------------------------------------------------------
bool NvParticlesPrimitiveShape::excludeAsLocator() const
{
    return false;
}

//-----------------------------------------------------------------------------------
bool NvParticlesPrimitiveShape::isTransparent() const
{
    return false;
}

//-----------------------------------------------------------------------------------
bool NvParticlesPrimitiveShape::drawLast() const
{
    return false;
}

//-----------------------------------------------------------------------------------
void NvParticlesPrimitiveShape::postConstructor()
{
    MFnDependencyNode nodeFn(thisMObject());
    nodeFn.setName("nvParticlesPrimitiveShape#");
}

//-----------------------------------------------------------------------------------
MStatus NvParticlesPrimitiveShape::initialize()
{
    MStatus status = MS::kSuccess;
    MFnNumericAttribute nAttrFn;
    MFnTypedAttribute tAttrFn;
    MFnCompoundAttribute cAttrFn;
    MFnMessageAttribute mAttrFn;
    MFnEnumAttribute eAttrFn;
    MFnUnitAttribute uAttrFn;
	MFnGenericAttribute gAttrFn;

    attrIsInterior = nAttrFn.create( "interior", "int", MFnNumericData::kBoolean, false, &status );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setStorable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setKeyable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setConnectable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( addAttribute( attrIsInterior ) );

    attrEnabled = nAttrFn.create( "enable", "ena", MFnNumericData::kBoolean, true, &status );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setStorable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setKeyable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setConnectable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( addAttribute( attrEnabled ) );

    attrExtents = nAttrFn.createPoint( "extents", "ext" );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setStorable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setKeyable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( nAttrFn.setConnectable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( addAttribute( attrExtents ) );

    attrPrimitive = eAttrFn.create( "primitive", "prim", 1, &status );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.setStorable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.setKeyable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.setConnectable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("sphere", NvParticlesPrimitiveShape_PRIMITIVE_SPHERE) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("plane", NvParticlesPrimitiveShape_PRIMITIVE_PLANE) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("box", NvParticlesPrimitiveShape_PRIMITIVE_BOX) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("capsule", NvParticlesPrimitiveShape_PRIMITIVE_CAPSULE) );
    CHECK_MSTATUS_AND_RETURN_IT( addAttribute( attrPrimitive ) );

    attrType = eAttrFn.create( "type", "pt", 0, &status );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.setStorable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.setKeyable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.setConnectable(true) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("none", 0) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("collision", NvParticlesPrimitiveShape_TYPE_COLLISION) );
    CHECK_MSTATUS_AND_RETURN_IT( eAttrFn.addField("emission", NvParticlesPrimitiveShape_TYPE_EMISSION) );
    CHECK_MSTATUS_AND_RETURN_IT( addAttribute( attrType ) );

    return status;
}

//-----------------------------------------------------------------------------------
MStatus NvParticlesPrimitiveShape::compute( const MPlug& plug, MDataBlock& block )
{
    MStatus status = MS::kUnknownParameter;
    MDataHandle outputData;

    return status;
}


//-----------------------------------------------------------------------------------
