/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PRIMITIVE_SHAPE_H_INCLUDED
#define NVPARTICLES_PRIMITIVE_SHAPE_H_INCLUDED

#include "gl_utils.h"
#include <maya/MStatus.h>
#include <maya/MObject.h>
#include <maya/MPxLocatorNode.h>
#include <maya/MDGMessage.h>

//-----------------------------------------------------------------------------------
/* 
NvParticlesPrimitiveShape:

This is just a placeholder in the Maya node graph for an nvParticles primitive's data.
The majority of the functionality happens inside the nvParticlesParticleShape.
*/
//-----------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------
#define NvParticlesPrimitiveShape_PRIMITIVE_SPHERE 1
#define NvParticlesPrimitiveShape_PRIMITIVE_PLANE 2
#define NvParticlesPrimitiveShape_PRIMITIVE_BOX 3
#define NvParticlesPrimitiveShape_PRIMITIVE_CAPSULE 4

#define NvParticlesPrimitiveShape_TYPE_COLLISION 1
#define NvParticlesPrimitiveShape_TYPE_EMISSION 2

//-----------------------------------------------------------------------------------
class NvParticlesPrimitiveShape : public MPxLocatorNode
{
    typedef MPxLocatorNode inherited;
public:
    NvParticlesPrimitiveShape();
	virtual ~NvParticlesPrimitiveShape();
	static void* creator();
	static MStatus initialize();

	virtual MStatus compute( const MPlug& plug, MDataBlock& block );

    virtual void postConstructor();

    virtual bool isBounded() const;
    virtual MBoundingBox boundingBox() const;

    virtual void draw( M3dView & view, const MDagPath & path, M3dView::DisplayStyle style, M3dView::DisplayStatus displaystatus);
    virtual bool excludeAsLocator() const;
	virtual bool isTransparent() const;
	virtual bool drawLast() const;

public:
	static MTypeId id;

	static MObject attrUpdateId;
    static MObject attrPrimitive;
    static MObject attrType;
    static MObject attrIsInterior;
    static MObject attrEnabled;
    static MObject attrExtents;
};

//-----------------------------------------------------------------------------------
#endif // NVPARTICLES_PRIMITIVE_SHAPE_H_INCLUDED
