/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#include <maya/MStatus.h>
#include <maya/MGlobal.h>
#include <maya/MFnPlugin.h>
#include <maya/MDagModifier.h>
#include "NvParticlesMayaStringResources.h"
#include "NvParticlesParticleShape.h"
#include "NvParticlesParticleShapeUI.h"
#include "NvParticlesPrimitiveShape.h"

// viewport 2.0...
#include <maya/MDrawRegistry.h>
#include "NvParticlesManager.h"

extern void nvParticles_init();

//-----------------------------------------------------------------------------------
namespace NvParticlesForMaya
{
static MString pluginPath;
}

//-----------------------------------------------------------------------------------
// Register all strings used by the plugin C++ code
static MStatus registerMStringResources(void)
{
    return MS::kSuccess;
}

//-----------------------------------------------------------------------------------
MStatus initializePlugin( MObject obj )
{
    MStatus status;
    MFnPlugin pluginFn( obj, "NVIDIA", "1.0", "Any");

    nvParticles_init();

	// Get the path of the plugin.
	// We can use this to set the environment correctly.
	NvParticlesForMaya::pluginPath = pluginFn.loadPath();

    //-----------------------------------------------------------------------------------
    // primitives...

    CHECK_MSTATUS_AND_RETURN_IT( pluginFn.registerNode( 
        kNvParticlesPrimitiveShapePluginName,
        NvParticlesPrimitiveShape::id,
        NvParticlesPrimitiveShape::creator,
        NvParticlesPrimitiveShape::initialize,
        MPxNode::kLocatorNode
        ) );

    //-----------------------------------------------------------------------------------
    // shapes

    CHECK_MSTATUS_AND_RETURN_IT( pluginFn.registerShape( 
        kNvParticlesParticleShapePluginName,
        NvParticlesParticleShape::id,
        &NvParticlesParticleShape::creator,
        &NvParticlesParticleShape::initialize,
        &NvParticlesParticleShapeUI::creator,
        &NvParticlesParticleShape::drawDbClassification
        ) );

    NvParticlesParticleShape::nodeRemovedCallback = MDGMessage::addNodeRemovedCallback(NvParticlesParticleShape::onNodeRemoved, kNvParticlesParticleShapePluginName, &status);
    CHECK_MSTATUS_AND_RETURN_IT(status);

    //-----------------------------------------------------------------------------------
    // Run MEL script for user interface initialization.
    if (MGlobal::mayaState() == MGlobal::kInteractive)
    {
        MString sCmd = "evalDeferred \"source \\\"nvParticles_initUI.mel\\\"\"";
        MGlobal::executeCommand( sCmd );
    }

    MGlobal::displayInfo(kNvParticlesPluginName " loaded.");
    return status;
}

//-----------------------------------------------------------------------------------
MStatus uninitializePlugin( MObject obj )
{
    MStatus   status;
    MFnPlugin pluginFn( obj );

    MMessage::removeCallback( NvParticlesParticleShape::nodeRemovedCallback );

	CHECK_MSTATUS( MHWRender::MDrawRegistry::deregisterGeometryOverrideCreator(
				NvParticlesParticleShape::drawDbClassification,
				NvParticlesParticleShape::drawRegistrantId) );

    CHECK_MSTATUS( pluginFn.deregisterNode( NvParticlesParticleShape::id ) );
    CHECK_MSTATUS( pluginFn.deregisterNode( NvParticlesPrimitiveShape::id ) );

    // Run MEL script for user interface cleanup.
    if (MGlobal::mayaState() == MGlobal::kInteractive)
    {
        MString sCmd = "evalDeferred \"__nvParticlesCleanupUI\"";
        MGlobal::executeCommand( sCmd );
    }

    MGlobal::displayInfo(kNvParticlesPluginName " unloaded.");

    return status;
}
//-----------------------------------------------------------------------------------
