/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_EXPORTS_H_INCLUDED
#define NVPARTICLES_EXPORTS_H_INCLUDED

//----------------------------------------------------------------------------------------------
// export:

#if defined( __WIN32__ ) || defined( _WIN32 )

// If we're not including this from a client build, specify that the stuff
// should get exported. Otherwise, import it.
#if defined( NVPARTICLES_STATIC_LIB )

#define _NvParticlesExport
#define _NvParticlesPrivate
#else
#   	if defined( NVPARTICLES_NONCLIENT_BUILD )
#       	define _NvParticlesExport __declspec( dllexport )
#   	else
#           if defined( __MINGW32__ )
#               define _NvParticlesExport
#           else
#       	    define _NvParticlesExport __declspec( dllimport )
#           endif
#   	endif
#define _NvParticlesPrivate
#endif

#else

// Enable GCC symbol visibility
#   if defined( NVPARTICLES_GCC_VISIBILITY )
#       define _NvParticlesExport  __attribute__ ((visibility("default")))
#       define _NvParticlesPrivate __attribute__ ((visibility("hidden")))
#   else
#       define _NvParticlesExport
#       define _NvParticlesPrivate
#   endif
#endif

#endif // NVPARTICLES_EXPORTS_H_INCLUDED
