/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_FORCES_H_INCLUDED
#define NVPARTICLES_FORCES_H_INCLUDED

#include "NvParticlesExports.h"
#include "NvParticlesTypes.h"
#include "NvParticlesForcesData.h"

namespace Easy
{
namespace NvParticles
{

//------------------------------------------------------------------------------------------
class _NvParticlesExport ParticleForces
{
public:
    ForcesData forces;
    int nextForceIndex;
    bool needUpload;
    std::string names[MAX_FORCES];
    static int debugLevel;
    static ForceData Invalid;

public:

    ParticleForces();

    /// Clear all items.
    ///
    void clear();

    /// Get an item by name.
	/// If it doesn't exist then the type of the returned item will be invalid.
    ///
    ForceData& get(const std::string& name);

	/// Add an item.
	///
    bool add(const std::string& name, ForceData f);
	bool add(const std::string& name, int type, float* origin=0, float* axis=0, float magnitude=0, float maxDistance=-1, float attenuation=0);

	/// Remove an item by name.
	///
    bool remove(const std::string& name);
};

//------------------------------------------------------------------------------------------
}
}

#endif // NVPARTICLES_FORCES_H_INCLUDED
