#ifndef NVPARTICLES_FORCES_DATA_H_INCLUDED
#define NVPARTICLES_FORCES_DATA_H_INCLUDED

#include <math_utils.h>

namespace Easy
{
namespace NvParticles
{

struct NVPARTICLES_ALIGN(16) ForceData
{
    enum {FORCE_NONE=0, FORCE_UNIFORM, FORCE_AIR, FORCE_DRAG, FORCE_VORTEX, FORCE_RADIAL, FORCE_TURBULENCE, FORCE_AXIS, NUM_FORCE_TYPES} ForceType;
    int type;
    vec3f axis;
    vec3f origin;
    float maxDistance;
    float magnitude;
    float attenuation;
};

const int MAX_FORCES = 10;

struct NVPARTICLES_ALIGN(16) ForcesData
{
    float time;
    float deltaTime;
    float globalDamping;
    float particleMass;
    float scale;
    float internalScale;
	// NB. this is unused if USE_FORCE_DATA_TEXTURE is defined.
    ForceData forces[MAX_FORCES];
};

}
}

#endif // NVPARTICLES_FORCES_DATA_H_INCLUDED
