/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PARTICLE_GRID_H_INCLUDED
#define NVPARTICLES_PARTICLE_GRID_H_INCLUDED

#include "NvParticlesExports.h"
#include "NvParticlesConfig.h"
#include "NvParticlesTypes.h"
#include "NvParticlesGridCuda.h"


namespace Easy
{
namespace NvParticles
{
class SystemBase;

class _NvParticlesExport ParticleGrid
{
public:
    uint maxParticles;
    boundingbox4f particles_bbox;

    Cu::Buffer h_particlesSortedIndexMem;
    Cu::Buffer d_particlesSortedIndexMem;
    Cu::Buffer d_particlesBucketIdMem;
    Cu::Buffer h_particlesBucketIdMem;
    Cu::Buffer d_cellsParticleStartMem, d_cellsParticleEndMem;
    Cu::Buffer h_cellsParticleStartMem, h_cellsParticleEndMem;
	Cu::Buffer d_itemUsedCells, h_itemUsedCells;

	uint adjacencyListSize;
	uint adjacencyListMaxItems;
	uint adjacencyListNumItems;
    uint adjacencyListPitch;
    Cu::Buffer d_neighborsBuffer;
    Cu::Buffer h_neighborsBuffer;

	uint boundaryMode;
	mat44f xform;
    uint num_occupied_cells;
    uint numCells;
    uint numAllocatedCells;
    vec4f bucketSize;
    uint3 bucketCount;
    bool drawLabels;

    bool _isGridDataCopiedToHost;

public:
    ParticleGrid();
    ~ParticleGrid();

    void _init();

    /// update the size of the cell volume.
    /// this modified the bbox to be quantized to the cellsize.
    bool setCellSize(boundingbox4f bbox, vec4f s, int nLevels=1);

    /// allocate the cell volume data structures based on numCells.
    bool _ensureCellVolume(uint3 bucketCount, int nLevels);

    /// allocate the buffers based on numParticles.
    bool setup(int n);

    /// Dump the debug info.
    void dump();
    void dump(int nItems, int step, long stream);

    /// copy the data back to the host.
    void copyGridDataToHost(long stream=0);

    /// render the grid.
    void render(bool cells=true, bool bbox=false, bool bounds=false);

    SpatialGrid::SpatialGridData hostData();
    SpatialGrid::SpatialGridData deviceData();

    const SpatialGrid::SpatialGridParameters* getParameters();
    SpatialGrid::SpatialGridParameters parameters;
};

}
}

#endif // NVPARTICLES_PARTICLE_GRID_H_INCLUDED
