/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_ITERATOR_CUDA_INLINE_H_INCLUDED
#define NVPARTICLES_ITERATOR_CUDA_INLINE_H_INCLUDED

//------------------------------------------------------------------------------------------
struct SimpleIterator
{
    int __iteratorIndex;

    inline static NVPARTICLES_CUDA_EXPORT 
    void pre(SimpleIterator& data, const int &i)
    {
    }

    inline static NVPARTICLES_CUDA_EXPORT 
    bool item(SimpleIterator& data, const int &i)
    {
        return false;
    }

    inline static NVPARTICLES_CUDA_EXPORT 
    void post(SimpleIterator& data, const int &i)
    {
    }
};

//------------------------------------------------------------------------------------------
template <class Iterator, int N>
inline static NVPARTICLES_CUDA_EXPORT 
void simpleIterate(Iterator& data, const int& i)
{
    Iterator::pre(data, i);

    // we can unroll this!
    //#pragma unroll(N)
    for (int c=0; c<N; ++c)
    {
        data.__iteratorIndex = c;
        if (!Iterator::item(data, i))
            break;
    }

    Iterator::post(data, i);
}

//------------------------------------------------------------------------------------------
template <class Iterator>
inline static NVPARTICLES_CUDA_EXPORT 
void simpleIterate(Iterator& data, const int& i, const int& N)
{
    Iterator::pre(data, i);

    for(int c=0; c<N; ++c)
    {
        data.__iteratorIndex = c;
        if (!Iterator::item(data, i))
            break;
    }

    Iterator::post(data, i);
}

//------------------------------------------------------------------------------------------

#endif // NVPARTICLES_ITERATOR_CUDA_INLINE_H_INCLUDED
