/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_MANAGER_H_INCLUDED
#define NVPARTICLES_MANAGER_H_INCLUDED

#include "NvParticlesExports.h"
#include "NvParticlesTypes.h"
#include "NvParticlesParticleSolverSpec.h"

namespace Easy
{
namespace NvParticles
{

//----------------------------------------------------------------------------------------------
/// This singleton controls the plugins and maintains the state shared by all
/// nvParticles objects in this application.
///
class _NvParticlesExport Manager : public Singleton<Manager>
{
private:
    virtual ~Manager();

    friend class Singleton<Manager>;

    ParticleSolverSpecs _particleSolverSpecs;

public:
    Manager();
    static Manager& getSingleton(void);

    GenericFactory<void> solverFactory;
    GenericFactory<void> rendererFactory;

    class ParticleRendererImpl* createRenderer(const std::string& name) const;
    class ParticleSolverImpl* createSolver(const std::string& name) const;

    ParticleSolverSpecPtr getParticleSolverSpec(const std::string& name);
};

}
}

#endif // NVPARTICLES_MANAGER_H_INCLUDED
