/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PARTICLE_RENDERER_H
#define NVPARTICLES_PARTICLE_RENDERER_H

#include "gl_utils.h"
#include "NvParticlesExports.h"
#include "NvParticlesParameters.h"

namespace Easy
{
namespace NvParticles
{

//------------------------------------------------------------------------------------------
class _NvParticlesExport ParticleRenderer
{
public:

    ParticleRenderer();

    ~ParticleRenderer();

    bool setType(const std::string& type);

    void update(const Parameters& bufferParams);

    void updateParameters(const Parameters& parameters);
    
    void readColorTexture();
    
    void readDepthTexture();

    bool valid();

    void renderDebugTextures(int x, int y, float scale);

    void resize(int w, int h, float fov);
    
    void render();

    bool bindDepthTexture(GLenum texTarget);

private:

    class ParticleRendererImpl* _impl;
    std::string _type;
    bool _initialized;
	bool _firstTime;

    void _init();

    void _destroy();
    void _ensureInit();
    

    void _createBuffers(int w, int h);

    Parameters _attributes;

    float _fov;
    int _window_w, _window_h;
    float _aspect;
    float _invFocalLen;

    GLuint _bgTexId;
    GLuint _particleTexId;
    GLuint _depthTexId;
};

//------------------------------------------------------------------------------------------
class _NvParticlesExport ParticleRendererImpl : public HasParameterSpecs
{
protected:
    int _numComponents;

    ParticleRendererImpl();
    virtual ~ParticleRendererImpl();

    virtual void initialize();
    virtual void render()=0;
    virtual void resize(int w, int h, float fov);
    virtual void updateParameters(Parameters& attributes);
    virtual void update(const Parameters& attributes, const Parameters& buffers);
    virtual void renderDebugTextures(int x, int y, float scale);

    virtual void _draw(GLenum type, int start=0, int count=-1, bool indexed=false);

    int _numParticles;

    float _fov;
    int _window_w, _window_h;
    float _aspect;
    float _invFocalLen;

    GLuint _posVbo, _velVbo, _colorVbo;
    GLuint _indexBuffer;

    float _debugTextureX;

    ParticleRenderer* _owner;

    friend class ParticleRenderer;
};

//------------------------------------------------------------------------------------------
}
}

#endif // NVPARTICLES_PARTICLE_RENDERER_H
