/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PARTICLE_RENDERER_IMPL_SPHERE_H_INCLUDED
#define NVPARTICLES_PARTICLE_RENDERER_IMPL_SPHERE_H_INCLUDED

#include "NvParticlesParticleRenderer.h"

namespace Easy
{
namespace NvParticles
{

//------------------------------------------------------------------------------------------
class ParticleRendererImpl_Sphere : public ParticleRendererImpl
{
public:
    ParticleRendererImpl_Sphere();

	static void* creator();
    virtual void initialize();
    virtual void render();
    virtual void updateParameters(Parameters& params);

public:
    bool _useLighting;
    float _particleRadius;
    float _colorScale;
    bool _useColor;
    vec4f _color;

    GLuint _shadedSphereProgram;
    GLuint _unshadedSphereProgram;
    GLuint _unshadedSphereMblurProgram;
};
//------------------------------------------------------------------------------------------

}
}

#endif // NVPARTICLES_PARTICLE_RENDERER_IMPL_SPHERE_H_INCLUDED
