#include "NvParticlesParticleSolverImpl.h"

#include "gl_utils.h"
#include "cuda_utils.h"
#include "std_utils.h"
#include "cuda_std_utils.h"

#include <cuda_runtime_api.h>
#include <cuda_gl_interop.h>
#include <math_constants.h>

#include <cassert>
#include <cstring>

#include "NvParticlesConfig.h"
#include "NvParticlesProfiler.h"
#include "NvParticlesGrid.h"
#include "CuBuffer.h"
#include "NvParticlesParameters.h"
#include "NvParticlesParticleModifier.h"

namespace Easy
{
namespace NvParticles
{

//------------------------------------------------------------------------------------------
ParticleSolverImpl::ParticleSolverImpl()
{
}

//------------------------------------------------------------------------------------------
ParticleSolverImpl::~ParticleSolverImpl()
{
}

//------------------------------------------------------------------------------------------
float ParticleSolverImpl::particleSpacing()
{
    return 1.0f;
}

//------------------------------------------------------------------------------------------
bool ParticleSolverImpl::defineBuffer(std::string name, const ParticleBufferSpec::Type type, const int flags, std::string renderSemantic)
{
	_bufferSpecs.insert(make_pair(name, ParticleBufferSpec(name, type, flags, renderSemantic)));
    return true;
}

//------------------------------------------------------------------------------------------
ParticleBufferSpecs& ParticleSolverImpl::getBufferDefinitions()
{
	return _bufferSpecs;
}

//------------------------------------------------------------------------------------------
}
}
