/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PARTICLESOLVERIMPL_H_INCLUDED
#define NVPARTICLES_PARTICLESOLVERIMPL_H_INCLUDED

#include "gl_utils.h"
#include "math_utils.h"
#include "NvParticlesConfig.h"
#include "NvParticlesManager.h"
#include "NvParticlesParticleBuffer.h"

namespace Easy
{
namespace NvParticles
{
class ParticleModifier;

//------------------------------------------------------------------------------------------
class _NvParticlesExport SimulatorContext_GPU
{
public:
	ParticleModifier* owner;
	long stream;
	int maxParticles;
	int numParticles;
	Cu::Buffer* firstDeadIndexPtr;
    vec3f boundsLow;
    vec3f boundsHigh;
};

//------------------------------------------------------------------------------------------
class _NvParticlesExport ParticleSolverImpl : public HasParameterSpecs
{
public:

    ParticleSolverImpl();
    virtual ~ParticleSolverImpl();

	// methods to overload:

	/// Set the solver attributes.
	///
	virtual void updateParameters(Parameters& attributes) = 0;

	/// Initialize the solver.
	/// Called once on setup.
	///
    virtual void initialize() = 0;

	/// Evaluate the solver.
	/// Called every update.
	///
    virtual void evaluate(SimulatorContext_GPU& cxt) = 0;

    /// return the optimal separation between particles.
	///
	virtual float particleSpacing();

    /// Add a per-particle buffer.
    /// @param name Name of the buffer.
    /// @param type The element type (FLOAT, FLOAT4, etc.)
    /// @param access How the buffer will be accessed (STATIC, DYNAMIC, TEMPORARY).
    ///
    bool defineBuffer(std::string name, const ParticleBufferSpec::Type type, const int flags=0, std::string renderSemantic="");

	ParticleBufferSpecs& getBufferDefinitions();

private:

    ParticleBufferSpecs _bufferSpecs;

	ParticleSolverImpl(const ParticleSolverImpl&);
    ParticleSolverImpl& operator=( const ParticleSolverImpl& );

    friend class ParticleModifier;
};

typedef SharedPtr<ParticleSolverImpl> ParticleSolverImplPtr;

//------------------------------------------------------------------------------------------
}
}

#endif // NVPARTICLES_PARTICLESOLVERIMPL_H_INCLUDED
