/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PARTICLESOLVERSPEC_H_INCLUDED
#define NVPARTICLES_PARTICLESOLVERSPEC_H_INCLUDED

#include "NvParticlesTypes.h"
#include "NvParticlesParticleBuffer.h"

namespace Easy
{
namespace NvParticles
{

//------------------------------------------------------------------------------------------
/// A simple spec class which encapsulates buffer definitions and
/// parameter definitions.
/// TODO: I should probably combine buffers with parameters as array types,
/// then I wouldn't need this.
///
class ParticleSolverSpec
{
public:

	ParameterSpecs parameterDefinitions;
    ParticleBufferSpecs bufferSpecs;
};

typedef SharedPtr<ParticleSolverSpec> ParticleSolverSpecPtr;
typedef std::map<std::string, ParticleSolverSpecPtr> ParticleSolverSpecs;

//------------------------------------------------------------------------------------------
}
}

#endif // NVPARTICLES_PARTICLESOLVERSPEC_H_INCLUDED
