/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PRIMITIVES_H_INCLUDED
#define NVPARTICLES_PRIMITIVES_H_INCLUDED

#include "NvParticlesExports.h"
#include "NvParticlesTypes.h"
#include "NvParticlesPrimitivesData.h"
#include <algorithm>

namespace Easy
{
namespace NvParticles
{

//------------------------------------------------------------------------------------------
/// This holds the device-buffers that is specific to the context.
///
class _NvParticlesExport PrimitiveResidentData
{
public:

    // we have a single device-buffer for all the xforms.
    SharedPtr<Cu::Buffer> d_transformData;
    SharedPtr<Cu::Buffer> h_transformData;

    PrimitiveResidentData();
	~PrimitiveResidentData();
    
    /// update the transform-data to have an interpolated matrix.
    ///
    void updateTransforms(class Primitives* owner, float t, long stream=-1);
};

//------------------------------------------------------------------------------------------
class _NvParticlesExport Primitives
{
public:

    PrimitiveGroup group;
    int nextPrimitiveIndex;
    bool needUpload;
    std::string names[NVPARTICLES_PRIMITIVE_MAX_COUNT];
    static Primitive Invalid;
    static int debugLevel;

public:

    Primitives();

    /// Clear all items.
    ///
    void clear();

	/// Get an item by name.
	/// If it doesn't exist then the type of the returned item will be invalid.
    ///
    Primitive& get(const std::string& name);

	/// Add an item.
	///
	bool add(const std::string& name, const Primitive& f);
	bool add(const std::string& name, int type, mat44f prevXform, mat44f xform, vec3f extents, int flags=Primitive::PRIMITIVE_FLAGS_NONE);

	/// Remove an item by name.
	///
    bool remove(const std::string& name);

	/// Render the item using OpenGL.
	///
    void render();

	/// Some OpenGL helper methods.
	///
    static void drawSphere(const Primitive& p);
    static void drawPlane(const Primitive& p);
    static void drawCapsule(const Primitive& p);
    static void drawBox(const Primitive& p);
};

//------------------------------------------------------------------------------------------
}
}

#endif // NVPARTICLES_PRIMITIVES_H_INCLUDED
