/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PRIMITIVES_DATA_H_INCLUDED
#define NVPARTICLES_PRIMITIVES_DATA_H_INCLUDED

#include "math_utils.h"

namespace Easy
{
namespace NvParticles
{
const int NVPARTICLES_PRIMITIVE_MAX_COUNT = 128;

//------------------------------------------------------------------------------------------
struct NVPARTICLES_ALIGN(16) PrimitiveTransform
{
    mat44f* xform;
};

//------------------------------------------------------------------------------------------
struct NVPARTICLES_ALIGN(16) Primitive
{
    enum PrimitiveType {PRIMITIVE_NONE=0, PRIMITIVE_SPHERE, PRIMITIVE_PLANE, PRIMITIVE_BOX, PRIMITIVE_CAPSULE, NUM_PRIMITIVE_TYPES=5};
    enum Flags {PRIMITIVE_FLAGS_NONE=0, PRIMITIVE_FLAGS_EXTERIOR=0, PRIMITIVE_FLAGS_INTERIOR=1};

    int type;
    vec3f extents;
    int flags;
    mat44f xform;
    mat44f prevXform;

    int transformIndex;
};

//------------------------------------------------------------------------------------------
struct NVPARTICLES_ALIGN(16) PrimitiveGroup
{
    float time;
    float deltaTime;
    float restitution;
    float particleRadius;
    float stiffness;
    float damping;
    float internalScale;
    float friction;

    int numPrimitives;

    Primitive primitives[NVPARTICLES_PRIMITIVE_MAX_COUNT];
    PrimitiveTransform transforms[NVPARTICLES_PRIMITIVE_MAX_COUNT];
};

//------------------------------------------------------------------------------------------
}
}

#endif // NVPARTICLES_PRIMITIVES_DATA_H_INCLUDED
