/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_PROFILER_H_INCLUDED
#define NVPARTICLES_PROFILER_H_INCLUDED

#include "NvParticlesExports.h"
#include "Profiler.h"

namespace Easy
{
namespace NvParticles
{

//-----------------------------------------------------------------------------------
class _NvParticlesExport Profiler : public Easy::Profiler::Manager, public Singleton<Profiler>
{
public:
	static Profiler& getSingleton(void);

	class Sample
	{
	public:
		Sample(const char *name, const char *type=0)
		{
			getSingleton().Push(name, type);
		}

		~Sample()
		{
			getSingleton().Pop();
		}
	};

};

#if 1

#define	NVPARTICLES_PROFILE(s) Easy::NvParticles::Profiler::Sample __profile(s)

#ifdef DEBUG
#define	NVPARTICLES_DEBUG_PROFILE(s) Easy::NvParticles::Profiler::Sample __profile(s)
#else
#define	NVPARTICLES_DEBUG_PROFILE(s)
#endif

#else

#define	NVPARTICLES_PROFILE(s)
#define	NVPARTICLES_DEBUG_PROFILE(s)

#endif

//-----------------------------------------------------------------------------------
}
}

#endif
