/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_TYPES_H_INCLUDED
#define NVPARTICLES_TYPES_H_INCLUDED

#include "NvParticlesExports.h"
#include <map>
#include <string>
#include <ostream>
#include <vector>
#include <cassert>
#include <iostream>
#include "std_utils.h"

#include "CuBuffer.h"
#include "math_utils.h"
#include "NvParticlesParameters.h"

namespace Easy
{
namespace NvParticles
{

//----------------------------------------------------------------------------------------------
inline void printError(const std::string& msg)
{
    std::cerr << msg << std::endl;
}

//----------------------------------------------------------------------------------------------
inline void printInfo(const std::string& msg)
{
    std::cout << msg << std::endl;
}

//----------------------------------------------------------------------------------------------
}
}

#endif
