#!/bin/bash

if [[ $0 == /* ]]; then
    me=$0
else
    me=`pwd`/$0
fi

bindir=`dirname "$me"`
DEV_ROOT=`dirname "$bindir"`

if [ ! -d "$DEV_ROOT/base" ]; then
    echo "Not development directory."
    exit
fi

INSTALL_PATH=$1
BUILD=$2

if [ -z "$INSTALL_PATH" ]; then
    echo "No destination path specified."
    echo "Usage: __install.sh <install_path> <build_type>"
    exit
fi

if [ -z "$BUILD" ]; then
    echo "No build specified."
    echo "Usage: __install.sh <install_path> <build_type>"
    exit
fi

# RedHat 7.2 doesn't recognize uname -o
# so if not cygwin then use normal uname (returns Linux instead of GNU/Linux)
osname=`uname -o 2> /dev/null|tr '[:upper:]' '[:lower:]'`
if [ "$osname" != "cygwin" ] ; then
    osname=`uname|tr '[:upper:]' '[:lower:]'`
fi

echo "Installing from: $DEV_ROOT to $INSTALL_PATH using $BUILD on $osname..."

mkdir -p $INSTALL_PATH

rsync -a --exclude "__*" $DEV_ROOT/*.TXT $INSTALL_PATH/
rsync -a --exclude "__*" $DEV_ROOT/scripts/* $INSTALL_PATH/bin/

# copy plugins:


if [ "$osname" == "cygwin" ] ; then
dllExt=".dll"
exeExt=".exe"
else
dllExt=".so"
exeExt=""
fi

mkdir -p $INSTALL_PATH/lib/$BUILD/third/mod
rsync -a  $DEV_ROOT/dist/$BUILD/* $INSTALL_PATH/lib/$BUILD/third/


if [ ! -d "$DEV_ROOT/library/__build/NvParticles/$BUILD" ] ; then
    echo "Missing $BUILD binaries."
    exit
fi

mkdir -p $INSTALL_PATH/lib/$BUILD/
mkdir -p $INSTALL_PATH/bin/$BUILD/
#rsync -a --exclude "*.a" $DEV_ROOT/library/__build/NvParticles/$BUILD/*NvParticles-$BUILD$dllExt $INSTALL_PATH/lib/$BUILD/
rsync -a --exclude "*.a" $DEV_ROOT/testing/__build/NvParticlesTest/$BUILD/NvParticlesTest-$BUILD$exeExt $INSTALL_PATH/bin/$BUILD/

# copy NvParticlesForMaya:

mkdir -p $INSTALL_PATH/NvParticlesForMaya/module/scripts/
rsync -a $DEV_ROOT/extras/NvParticlesForMaya/scripts/* $INSTALL_PATH/NvParticlesForMaya/module/scripts/
mkdir -p $INSTALL_PATH/NvParticlesForMaya/module/icons/
rsync -a $DEV_ROOT/extras/NvParticlesForMaya/icons/* $INSTALL_PATH/NvParticlesForMaya/module/icons/
#mkdir -p $INSTALL_PATH/NvParticlesForMaya/module/
#rsync -a $DEV_ROOT/extras/NvParticlesForMaya/module.txt $INSTALL_PATH/NvParticlesForMaya/module/
mkdir -p $INSTALL_PATH/NvParticlesForMaya/doc/
rsync -a $DEV_ROOT/extras/NvParticlesForMaya/doc/* $INSTALL_PATH/NvParticlesForMaya/doc/
mkdir -p $INSTALL_PATH/NvParticlesForMaya/plug-ins/

rsync -a --exclude "*.a" $DEV_ROOT/extras/NvParticlesForMaya/__build/NvParticlesForMaya/$BUILD/*NvParticlesForMaya-$BUILD.* $INSTALL_PATH/NvParticlesForMaya/plug-ins/

rsync -a --exclude "__*" $DEV_ROOT/extras/NvParticlesForMaya/maya/* $INSTALL_PATH/NvParticlesForMaya/examples/
