#!/bin/bash

BUILD=$1
shift

export NVPARTICLES_DEV_PATH=`pwd`

# setup CUDA:

if [ -z $CUDA_LIB_PATH ]; then
    export CUDA_LIB_PATH=/usr/local/cuda/lib64
fi

export LD_LIBRARY_PATH=$CUDA_LIB_PATH:$LD_LIBRARY_PATH

# setup NvParticles:

export LD_LIBRARY_PATH=$NVPARTICLES_DEV_PATH/base/__build/NvParticlesBase/$BUILD/:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=$NVPARTICLES_DEV_PATH/library/__build/NvParticles/$BUILD/:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=$NVPARTICLES_DEV_PATH/dist/$BUILD/:$LD_LIBRARY_PATH

export NVPARTICLES_INSTALL_PATH=$NVPARTICLES_DEV_PATH

export __GL_FSAA_MODE=5

# setup NvParticlesForMaya:

export MAYA_PLUG_IN_PATH=$NVPARTICLES_DEV_PATH/extras/NvParticlesForMaya/__build/NvParticlesForMaya/$BUILD/:$MAYA_PLUG_IN_PATH
export MAYA_SCRIPT_PATH=$NVPARTICLES_DEV_PATH/extras/NvParticlesForMaya/scripts:$MAYA_SCRIPT_PATH
export XBMLANGPATH=$NVPARTICLES_DEV_PATH/extras/NvParticlesForMaya/icons:$XBMLANGPATH

# setup Maya:

export MAYA_NO_VERTEX_ARRAY_SELECT=1
export MAYA_NO_PARALLEL_MEMCPY=1

if [ -z $MAYA_LOCATION ]; then
    export MAYA_LOCATION=/usr/autodesk/maya2012-x64
fi

ldd $NVPARTICLES_DEV_PATH/extras/NvParticlesForMaya/__build/NvParticlesForMaya/$BUILD/libNvParticlesForMaya-$BUILD.so
$MAYA_LOCATION/bin/maya $@
