#!/bin/bash

BUILD=$1

if [ -z "$BUILD" ]; then
    echo "You must specify which build to run. (e.g. \"run_test_linux64 linux64_gcc4.1\")"
    exit
fi

# setup CUDA:

if [ -z $CUDA_LIB_PATH ]; then
    export CUDA_LIB_PATH=/usr/local/cuda/lib64
fi

export LD_LIBRARY_PATH=$CUDA_LIB_PATH:$LD_LIBRARY_PATH

# setup NvParticles:

if [ -z $NVPARTICLES_INSTALL_PATH ]; then

    echo "Searching for NVPARTICLES_INSTALL_PATH..."

    #
    #  Create the full pathname of the invoked binary.
    #
    if [[ $0 == /* ]]; then
	    me=$0
    else
	    me=`pwd`/$0
    fi

    bindir=`dirname "$me"`
    export NVPARTICLES_INSTALL_PATH=`dirname "$bindir"`

    if [ ! -d $NVPARTICLES_INSTALL_PATH ]; then
        echo "Error: Bad NVPARTICLES_INSTALL_PATH = $NVPARTICLES_INSTALL_PATH"
        exit
    fi
fi

echo "NVPARTICLES_INSTALL_PATH = $NVPARTICLES_INSTALL_PATH"

export LD_LIBRARY_PATH=$NVPARTICLES_INSTALL_PATH/lib/$BUILD:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=$NVPARTICLES_INSTALL_PATH/lib/$BUILD/third:$LD_LIBRARY_PATH

# setup NvParticlesForMaya:

#export MAYA_MODULE_PATH=$NVPARTICLES_INSTALL_PATH/NvParticlesForMaya//module
export MAYA_PLUG_IN_PATH=$NVPARTICLES_INSTALL_PATH/NvParticlesForMaya/plug-ins:$MAYA_PLUG_IN_PATH
export MAYA_SCRIPT_PATH=$NVPARTICLES_INSTALL_PATH/NvParticlesForMaya/module/scripts:$MAYA_SCRIPT_PATH
export XBMLANGPATH=$NVPARTICLES_INSTALL_PATH/NvParticlesForMaya/module/icons:$XBMLANGPATH

# setup Maya:

export __GL_FSAA_MODE=5
export MAYA_NO_VERTEX_ARRAY_SELECT=1
export MAYA_NO_PARALLEL_MEMCPY=1

if [ -z $MAYA_LOCATION ]; then
    export MAYA_LOCATION=/usr/autodesk/maya2012-x64
fi

#ldd $NVPARTICLES_INSTALL_PATH/NvParticlesForMaya/maya2012/plug-ins/NvParticlesForMaya-$BUILD.so
shift
$MAYA_LOCATION/bin/maya -proj $NVPARTICLES_INSTALL_PATH/NvParticlesForMaya/examples $@

