#!/bin/bash

BUILD=$1

if [ -z "$BUILD" ]; then
    echo "You must specify which build to run. (e.g. \"run_test_linux64 linux64_gcc4.1\")"
    exit
fi

# setup CUDA:

if [ -z $CUDA_LIB_PATH ]; then
    export CUDA_LIB_PATH=/usr/local/cuda/lib64
fi

export LD_LIBRARY_PATH=$CUDA_LIB_PATH:$LD_LIBRARY_PATH

# setup NvParticles:

if [ -z $NVPARTICLES_INSTALL_PATH ]; then

    echo "Searching for NVPARTICLES_INSTALL_PATH..."

    #
    #  Create the full pathname of the invoked binary.
    #
    if [[ $0 == /* ]]; then
	    me=$0
    else
	    me=`pwd`/$0
    fi

    bindir=`dirname "$me"`
    export NVPARTICLES_INSTALL_PATH=`dirname "$bindir"`

    if [ ! -d $NVPARTICLES_INSTALL_PATH ]; then
        echo "Error: Bad NVPARTICLES_INSTALL_PATH = $NVPARTICLES_INSTALL_PATH"
        exit
    fi
fi

echo "NVPARTICLES_INSTALL_PATH = $NVPARTICLES_INSTALL_PATH"

export LD_LIBRARY_PATH=$NVPARTICLES_INSTALL_PATH/lib/$BUILD:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=$NVPARTICLES_INSTALL_PATH/lib/$BUILD/third:$LD_LIBRARY_PATH

# setup app:

export __GL_FSAA_MODE=5

shift
$NVPARTICLES_INSTALL_PATH/bin/$BUILD/NvParticlesTest-$BUILD $@

