@echo off
setlocal

set BUILD=win64
set app_exec=run_test_%BUILD%.bat
set cmd_base=%~dp0


:setup_args
set app_args=%1 %2 %3 %4 %5 %6 %7 %8 %9

rem #### do we have NVPARTICLES_INSTALL_PATH setup? #### 
if defined NVPARTICLES_INSTALL_PATH goto :setup

rem #### search for the location ####
echo "Searching for NVPARTICLES_INSTALL_PATH..."


rem // find the app_exec that is in the current running path or the path
set app_exec_path=""
set P2=%cmd_base%;%PATH%
for %%i in (%app_exec%) do if NOT "%%~$P2:i"=="" set app_exec_path=%%~$P2:i
rem for %%e in (%PATHEXT%) do @for %%i in (%app_exec%%%e) do @if NOT "%%~$P2:i"=="" set app_exec_path=%%~$P2:i

if %app_exec_path%=="" goto :error_no_app_exec_path

rem #### determine the path from the executable location #### 
rem echo app_exec_path = %app_exec_path%

set NVPARTICLES_INSTALL_PATH=%cmd_base%..

if not defined NVPARTICLES_INSTALL_PATH goto :error_no_loc


:setup

echo NVPARTICLES_INSTALL_PATH = %NVPARTICLES_INSTALL_PATH%

rem #### prepare to run from specified location ####
if not exist %NVPARTICLES_INSTALL_PATH%\bin\%BUILD%\NvParticlesTest-%BUILD%.exe goto :error_no_app_exec_path


:runprog

rem #### run from specified location ####
set PATH=%NVPARTICLES_INSTALL_PATH%\lib\%BUILD%;%NVPARTICLES_INSTALL_PATH%\lib\%BUILD%\third;%PATH%

set app_cmd=%NVPARTICLES_INSTALL_PATH%\bin\%BUILD%\NvParticlesTest-%BUILD%.exe
echo "Executing: %app_cmd%"
%app_cmd% %app_args%
goto :end

:error_no_app_exec_path
echo Error: I can't find executable
goto :end

:error_no_loc
echo Error: I can't determine NVPARTICLES_INSTALL_PATH
goto :end

:end

endlocal
