/*
 * Copyright 1993-2012 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 */

#ifndef NVPARTICLES_SOLVER_IMPL_WCSPH_H_INCLUDED
#define NVPARTICLES_SOLVER_IMPL_WCSPH_H_INCLUDED

#include "NvParticlesParticleSolverImpl.h"
#include "gl_utils.h"
#include <cuda_gl_interop.h>

namespace Easy
{
namespace NvParticles
{
namespace Wcsph
{

//------------------------------------------------------------------------------------------
/// Class representing the solver implementation.
///
class Solver : public ParticleSolverImpl
{
    typedef ParticleSolverImpl inherited;

	int colorStyle;
    int debugLevel;

	int subSteps; // number of times to evaluate.
	/// This contains all the options for the particle system.
    struct InternalParameters* parameters;
    float cflDeltaTime;
    cudaGraphicsResource* glResourceDisplacement;
    int oldGlTexDisplacement;
    int oldGlTexDisplacementSize;
    Cu::Buffer fieldBuffer;
    Cu::Buffer fieldBuffer2;

public:
	/// Create this object.
	///
	static void* creator();

	/// Initialize the ParameterSpecs.
	///
	virtual void initialize();

	Solver();
	virtual ~Solver();

	/// Update the internal data from ParameterValues.
	///
	virtual void updateParameters(Parameters& attributes);

	/// Evaluate the system.
	///
	virtual void evaluate(SimulatorContext_GPU& cxt);

	/// Return the particle spacing.
	///
	virtual float particleSpacing();

};
//------------------------------------------------------------------------------------------
}
}
}

#endif // NVPARTICLES_SOLVER_IMPL_WCSPH_H_INCLUDED
